'
'  This program evaluates mouse cursor motion characteristics for the
' bios video mode (hexadecimal) specified on the command line.  It
' requires the auxiliary library QB.LIB when you LINK.
'
'  Define REGISTERS variable type.
'
TYPE REGISTERS
AX AS INTEGER
BX AS INTEGER
CX AS INTEGER
DX AS INTEGER
BP AS INTEGER
SI AS INTEGER
DI AS INTEGER
FLAGS AS INTEGER
DS AS INTEGER
ES AS INTEGER
END TYPE
DIM INREGS AS REGISTERS,OUTREGS AS REGISTERS,CMODE AS INTEGER
'
'  Make sure rodent driver is installed.
'
INREGS.AX=0
CALL INTERRUPTX(&H33,INREGS,OUTREGS)
IF OUTREGS.AX=&HFFFF THEN
'
'  Driver is installed.
'
'  Get video mode to be analyzed from command line.  (Watch out for no
' command line argument.)
'
MODE=0
IF COMMAND$<>"" THEN MODE=VAL("&H"+COMMAND$)
'
'  Get current video mode.
'
INREGS.AX=&HF00
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
CMODE=OUTREGS.AX AND &HFF
'
'  If no video mode specified on command line, use current video mode.
'
IF MODE=0 THEN MODE=CMODE
'
'  Set video mode.  (It's done differently for VESA modes than for
' others.)
'
INREGS.AX=MODE     'This won't apply for VESA mode.
IF MODE>255 THEN
'
'  VESA video mode
'
INREGS.AX=&H4F03
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
CMODE=OUTREGS.BX
INREGS.BX=MODE
INREGS.AX=&H4F02
END IF
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
'
'  Attempt to set mouse cursor position and then read cursor position.
' If position read doesn't agree with position set, set position was
' invalid.  Mouse motion limits are the maximum values at which such
' agreement is achieved.
'
XMAX=0
KX=0
FOR I=0 TO 8000
INREGS.AX=4
INREGS.CX=I
INREGS.DX=0
CALL INTERRUPTX(&H33,INREGS,OUTREGS)
INREGS.AX=3
CALL INTERRUPTX(&H33,INREGS,OUTREGS)
IF OUTREGS.CX=I THEN
KX=KX+1
XMAX=I
END IF
NEXT I
YMAX=0
KY=0
FOR I=0 TO 5000
INREGS.AX=4
INREGS.CX=0
INREGS.DX=I
CALL INTERRUPTX(&H33,INREGS,OUTREGS)
INREGS.AX=3
CALL INTERRUPTX(&H33,INREGS,OUTREGS)
IF OUTREGS.DX=I THEN
KY=KY+1
YMAX=I
END IF
NEXT I
'
'  Since SVGA mode may be involved, don't use standard basic PRINT
' command.  Use bios function instead.
'
CALL BPRINT("VIDEO MODE = "+HEX$(MODE)+"h",INREGS,OUTREGS)
CALL BPRINT("MAXIMUM COLUMN AND ROW = " +STR$(XMAX)+STR$(YMAX),INREGS,OUTREGS)
'
'  Get incrementation (correspondence between mouse motion and screen
' coordinates).
'
IF KX>1 THEN
DX=XMAX/(KX-1)
CALL BPRINT("COLUMN INCREMENTATION = " +STR$(DX),INREGS,OUTREGS)
END IF
IF KY>1 THEN
DY=YMAX/(KY-1)
CALL BPRINT("ROW INCREMENTATION = " +STR$(DY),INREGS,OUTREGS)
END IF
CALL BPRINT("",INREGS,OUTREGS)
CALL BPRINT("Press a key to continue...",INREGS,OUTREGS)
'
'  Pause in order to delay screen clear.
'
10 IF INKEY$="" THEN GOTO 10
'
'  Put screen back in video mode that existed before program was run.
'
IF CMODE<256 THEN
INREGS.AX=CMODE
ELSE
INREGS.AX=&H4F02
INREGS.BX=CMODE
END IF
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
SCREEN 0
ELSE
'
'  Driver not installed.
'
PRINT "INSTALL YOUR RODENT DRIVER!"
END IF
END
'
'  Bios print routine to print character string S$
'
SUB BPRINT(S$,INREGS AS REGISTERS,OUTREGS AS REGISTERS)
DIM A(1 TO 21) AS LONG
DEF SEG=VARSEG(A(1))
OS=VARPTR(A(1))
FOR I=1 TO LEN(S$)
C$=MID$(S$,I,1)
POKE OS,ASC(C$)
OS=OS+1
NEXT I
POKE OS,13
OS=OS+1
POKE OS,10
OS=OS+1
POKE OS,ASC("$")
INREGS.AX=&H900
INREGS.DS=VARSEG(A(1))
INREGS.DX=VARPTR(A(1))
CALL INTERRUPTX(&H21,INREGS,OUTREGS)
END SUB
